/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.domain.ui;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryFilter$FilterType;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.util.a.e;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonIgnoreProperties(value={"searchFilters", "queryPage", "querySort", "filters"})
public class Grid<T> {
    private long totalRows = 0L;
    private QueryData queryData;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    private List<T> data = Collections.emptyList();
    private List<QueryFilter> searchFilters = null;
    private List<QueryFilter> filters = null;

    public Grid() {
    }

    public Grid(QueryData qData) {
        this.queryData = qData;
    }

    public void initSearch(String searchKey, String ... filed) {
        if (searchKey.isEmpty()) {
            return;
        }
        searchKey = searchKey.replace("\\", "\\\\");
        if (this.searchFilters == null) {
            this.searchFilters = new ArrayList<QueryFilter>();
        }
        for (String string : filed) {
            this.searchFilters.add(new QueryFilter(string, searchKey, QueryFilter$FilterType.like));
            this.searchFilters.add(new QueryFilter(string, e.d(searchKey), QueryFilter$FilterType.like));
        }
    }

    public void initFilters(String filterName, Object filterValue, QueryFilter$FilterType filterType) {
        if (filterName.isEmpty()) {
            return;
        }
        if (this.filters == null) {
            this.filters = new ArrayList<QueryFilter>();
        }
        this.filters.add(new QueryFilter(filterName, filterValue, filterType));
    }

    public void initFilters(Map<String, Object> filters) {
        if (filters == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            this.initFilters(entry.getKey(), entry.getValue(), QueryFilter$FilterType.eq);
        }
    }

    public QueryPage getQueryPage() {
        int n;
        int n2 = this.queryData.getCurrentPage();
        if ((long)((n2 - 1) * (n = this.queryData.getCurrentPageSize())) >= this.totalRows || n2 == 0) {
            n2 = (int)Math.ceil((double)this.totalRows / (double)n);
            if (n2 == 0) {
                n2 = 1;
            }
            this.queryData.setCurrentPage(n2);
        }
        return new QueryPage(n2 - 1, n);
    }

    public QuerySort getQuerySort() {
        String string = this.queryData.getSortName();
        if (string.isEmpty()) {
            return null;
        }
        String[] stringArray = string.split(",");
        String string2 = this.queryData.getSortOrder();
        return new QuerySort(string2, Arrays.asList(stringArray));
    }

    public List<QueryFilter> getSearchFilters() {
        return this.searchFilters;
    }

    public QueryData getQueryData() {
        return this.queryData;
    }

    public void setQueryData(QueryData queryData) {
        this.queryData = queryData;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setData(List<T> data) {
        if (data != null) {
            this.data = data;
        }
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(long totalRows) {
        this.totalRows = totalRows;
    }

    public List<QueryFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<QueryFilter> filters) {
        this.filters = filters;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

